﻿//////////////////////////////////////////////
// InfiniteBitMask.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// Standards
#include <vector>

/// Class ------------------------------------

namespace nkGraphics
{
	class InfiniteBitMask
	{
		public :
		
			// Constructeur, destructeur
			InfiniteBitMask () ;
			InfiniteBitMask (const InfiniteBitMask& other) ;
			InfiniteBitMask (InfiniteBitMask&& other) ;
			~InfiniteBitMask () ;

			// Ajout d'un bit
			void setBit (unsigned int index, bool value) ;
			// Reset
			void clear () ;

			// Obtention d'un bit
			bool getBit (unsigned int index) const ;
			// Obtention de l'ordre actuel (bit set le plus haut)
			unsigned int getOrder () const ;

			// Sous-routines
			// Comparaison
			bool checkSubPartEquality (const InfiniteBitMask& other, unsigned int begin, unsigned int end) const ;

			// Accès par opérateur
			std::vector<bool>::reference operator[] (size_t index) ;
			bool operator[] (size_t index) const ;
			// Comparaison
			bool operator== (const InfiniteBitMask& other) const ;
			bool operator!= (const InfiniteBitMask& other) const ;
			bool operator< (const InfiniteBitMask& other) const ;
			// Assignement
			InfiniteBitMask& operator= (const InfiniteBitMask& other) ;
			InfiniteBitMask& operator= (InfiniteBitMask&& other) ;

		private :
		
			std::vector<bool> _bits ;
	} ;
}